<?php
// fetch_pending.php
session_start();
require 'config.php';

// Ensure the user is authenticated
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized access.']);
    exit;
}

// Check if the request is to fetch pending payments
if ($_GET['fetch_pending'] ?? '' !== '1') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request.']);
    exit;
}

// Fetch search parameter for Pending Payments
$search_pending = $_GET['search_pending'] ?? '';
$pending_limit = 50;
$pending_page = isset($_GET['pending_page']) && is_numeric($_GET['pending_page']) ? (int)$_GET['pending_page'] : 1;
$pending_offset = ($pending_page - 1) * $pending_limit;

// Prepare Pending Payments Query with Search
$pendingSql = "SELECT 
                inE.id as in_id, 
                inE.license_plate, 
                inE.weight_kg as in_weight, 
                inE.timestamp as in_time,
                inE.image1, inE.image2, inE.image3,
                outE.id as out_id,
                outE.weight_kg as out_weight,
                outE.timestamp as out_time,
                outE.out_image,
                outE.out_image2,
                outE.out_image3
            FROM entries inE
            JOIN entries outE
                ON (
                   (
                       inE.license_plate = outE.license_plate
                       AND inE.license_plate <> 'unknown'
                       AND outE.timestamp >= inE.timestamp - INTERVAL 10 SECOND
                   )
                   OR
                   (inE.license_plate = 'unknown' AND outE.license_plate = 'unknown' AND inE.timestamp = outE.timestamp)
                )
                AND inE.direction = 'in'
                AND outE.direction = 'out'
            WHERE inE.processed = 0 AND outE.processed = 0";

$pendingBindParams = [];

// Apply search filter if provided
if (!empty($search_pending)) {
    $pendingSql .= " AND inE.license_plate LIKE :search_pending";
    $pendingBindParams[':search_pending'] = '%' . $search_pending . '%';
}

$pendingSql .= " ORDER BY (inE.license_plate='unknown') DESC, inE.timestamp DESC LIMIT :limit OFFSET :offset";

$pendingStmt = $pdo->prepare($pendingSql);
if (!empty($search_pending)) {
    $pendingStmt->bindValue(':search_pending', '%' . $search_pending . '%');
}
$pendingStmt->bindValue(':limit', (int)$pending_limit, PDO::PARAM_INT);
$pendingStmt->bindValue(':offset', (int)$pending_offset, PDO::PARAM_INT);
$pendingStmt->execute();
$pendingRows = $pendingStmt->fetchAll(PDO::FETCH_ASSOC);

// Return data as JSON
echo json_encode(['status' => 'success', 'data' => $pendingRows]);
exit;
?>
